 module Main where
-------------------------------------------------
-- A example of Transactional cache usage (TCache.hs)
-- (Something like the Java Hibernate)
-- Author: Alberto Gómez Corona Nov 2006
-- Language: Haskell
-- Terms of use: you can do whatever you want
-- with this code as long as you keep this notice
------------------------------------------------

import Data.TCache.TMVar

import Control.Concurrent
import Debug.Trace

debug a b= trace b a

-- The data elements to be used in the example

data  Data=   Data Int String deriving (Read, Show)

 

instance IResource Data where
        keyResource         (Data i _)= show i   
        serialize x= show x
        deserialize x= read x
        defPath _ = "data/"  -- directory where the data is stored.
        
        -- other definable methods: readResource, writeResource delResource. here the default persistence in files are used
     


main= do
       
        putStrLn "see the source code of this example"
        putStrLn "This program test the caching and cleaning and re-retrieval and update of the cache"
        
        putStrLn "asyncronous write every 10 seconds, 100 elems max cache size"
        putStrLn "default policy (defaultCheck) for clearing the cache is to reduce the cache to half of max sixe when size exceeds the max"
        clearSyncCacheProc (refcache :: Cache Data) 10 defaultCheck 100 
        putStrLn ""
        putStrLn "create resources" 
        putStrLn " (acces no resources and return two new Data objects defined in items)"
        withResources[] (\_ ->[Data i "olddata" | i <-[1..200]])

        putStrLn ""
        putStrLn "after 10 seconds, 200 files  have been created in the folder \"data\""
        putStrLn "because 200 exceeds the maximum cache size (100) defaultCheck will discard the 150  older elems  to reduce the cache to a half"
        putStrLn "This is the behaviour defined in defaultCheck."
        
        putStrLn ""
        putStrLn" wait 20 seconds  to let the next write cycle to enter (every 10 seconds, set in clearSyncCacheProc)" 
        
        threadDelay 2000000
        
        putStrLn ""        
        putStrLn "modifyng"
        putStrLn "update all the list. discarded elems from cache are also updated atomically"
        withResources[]  (\_ ->[Data i "newdata" | i <-[1..200]]) 
        
        putStrLn "state in disk is also atomically written."
        
        putStrLn ""       
        putStrLn "updated. wait 20 seconds to let the next write cycle to enter (every 10 seconds)" 
        threadDelay 20000000
        putStrLn "Done. Please check that the \".data/\" directory has 200 files with \"newdata\" content in them"